/**
 * Created by Acer on 2016-04-18.
 */
var valid_date = function(){
    var current_index = parseInt($("#current_index").val());
    if(current_index != 1) {
        if ($("#id_cometime").val() == "" || $("#id_endtime").val() == "") {
            layer.alert(gettext("请选择开始日期和结束日期"), {
                icon: 2,
                title: gettext("提示"),
                area: ["auto", "auto"],
                btn: []
            });
            return false;
        }
        var st = new Date($("#id_cometime").val().replace(/-/g, "/"));
        var et = new Date($("#id_endtime").val().replace(/-/g, "/"));
        if (st > et) {
            layer.alert(gettext("开始日期不能大于结束日期"), {
                icon: 2,
                title: gettext("提示"),
                area: ["auto", "auto"],
                btn: []
            });
            return false;
        }
    }
    return true;
};


var setPostData = function(){
    var depts = [];
	var users = [];
    var current_index = parseInt($("#current_index").val());
    if($("#id_dept_all").attr("checked")) {
        //以部门为主
        $("input[name='dept_child']").val($("input[name='deptIDschecked_child']:checkbox").attr("checked") ? "1" : "0")
        //			alert("before get deptid")
        $("#id_divsearch").find("input[name='deptIDs']").each(
            function () {
                depts.push($(this).val());
            });
        $("input[name='DeptIDs']").val(depts.length == 0 ? "" : depts.toString());
        $("input[name='UserIDs']").val("");
    } else {
        //以选择的人员为主
        users = $("#id_divsearch").find("div[id^='emp_select_']").get(0).g.get_store_emp();
        $("input[name='UserIDs']").val(users.length == 0 ? "" : users.toString());
        $("input[name='DeptIDs']").val("");
    }
    return true;
};


var get_where = function(){
	if (!valid_date()){
        return false;
    }
	if (!setPostData()){
        return false;
    }
	var where = ["pure"];
	$("#id_calculateform input").each(function(){
		if ($(this).attr("name")!= ""){
			where.push($(this).attr("name")+"="+$(this).val())
		}
	});
	return where;
}


function RequestGrid(index, url){
    $("#current_index").val(index);
    var where=get_where();
    if(where){
        var url = url+"?"+where.join("&");
        $("#grid_frame").attr("src",url);
    }else{
        return ;
    }
}

function ReportClick(elem, index, url){
    var alert_options = {
        icon: 4,
        title:gettext('提示'),
        btn: []
    };
    $.ajax({
        url: "/payroll/calculate_progress/?calc=payroll",
        type: 'GET',
        dataType: 'json',
        success: function(callback){
            if(callback.index == '1' && index != 1){
                layer.alert(gettext("Please wait for calculating finish."), alert_options);
                return
            }
            $("#report_tabs a").removeClass('current');
            $("#report_tabs a"+elem).addClass('current');
            RequestGrid(index, url);
        },
        error: function(){
            layer.alert(gettext("System error."), alert_options);
        }

    });
};

function SalaryFormula(){
    ReportClick("#salary_formula", 1, "/page/payroll/SalaryFormula/");
};

function SalaryDetail(){
    ReportClick("#salary_detail", 2, "/page/payroll/SalaryDetail/");
};

function MonthlySalary(){
    ReportClick("#monthly_salary", 3, "/page/payroll/MonthlySalary/");
};

function SalaryChange(){
    ReportClick("#salary_change", 4, "/page/payroll/SalaryChangeLog/");
};
function WPSReport(){
    ReportClick("#wps_report", 5, "/page/payroll/WPSReport/");
};

function refresh_current_page(){
    var current_index = parseInt($("#current_index").val());
    switch(current_index){
        case 1:
            SalaryFormula();
            break;
        case 2:
            SalaryDetail();
            break;
        case 3:
            MonthlySalary();
            break;
        case 4:
            SalaryChange();
            break;
        case 5:
            WPSReport();
            break;
        default : break;
    }
};

function ProgressRefresh(layero, index, calc){
    $("#id_progress div.info-panel").empty();
    if(calc == "att"){
        $("#id_tip").text(gettext("Calculating Attendance...."));
    }
    if(calc == "payroll"){
        $("#id_tip").text(gettext("Calculating Payroll...."));
    }
    $("#id_processer").progressBar(0, {increment:100,barImage: '/media/images/progressbg_green.gif?'});
    $("#id_totally").text('');
    $("#id_calculated").text('');
    $("#id_waiting").text('');
    //$("#id_processer").show();
    var timer = null;
    var tmp = null;
    timer = setInterval(function(){
        var stamp = new Date().getTime();
        $.ajax({
            url: "/payroll/calculate_progress/?calc="+calc,
            type: 'GET',
            dataType: 'json',
            success: function(callback){
                if(callback.index == '1'){
                    var data = callback.datas;
                    var calculated = data['calculated'];
                    var totally = data['totally'];
                    var waiting = data['waiting'];
                    var progress = data['progress'];
                    $("#id_totally").text(totally);
                    $("#id_calculated").text(calculated);
                    $("#id_waiting").text(waiting);
                    if(tmp != progress){
                        tmp = progress;
                        $("#id_progresser").progressBar(progress, {increment:100,barImage: '/media/images/progressbg_green.gif?stamp='+stamp});
                        $("#id_progresser").show();
                    }
                }else{
                    layer.close(index)
                    clearInterval(timer);
                }
            },
            error: function(){

            }

        });
    }, 1000)
    return timer;
};
function calculate(calc){
    var confirm_options = {
        icon: 3,
        title:gettext('提示'),
        skin: 'action-dialog',
        btn: [gettext("确定"), gettext("取消")]
    };
    layer.confirm(gettext("统计的时间可能会较长，请耐心等待"), confirm_options, function(index){
        layer.close(index);
        var timer= null;
        var att = null;
        var options = {
            title: 'Progress',
            skin: 'action-dialog',
            area: ['auto', 'auto'],
            content: $("#id_progress"),
            success: function (layero, index) {
                att = index;
                timer = ProgressRefresh(layero, index, calc);
                //;
            },
            cancel: function(index){
                clearInterval(timer);
                timer = true;
            },
            end: function(index){
                clearInterval(timer);
                timer = true;
            }
        };
        $(document).layerDialog(options);
        var where=get_where();
        var url = "/payroll/payroll_calculate/?";
        where.push("calc="+calc);
        if(where) {
            url += where.join("&");
        }
        var alert_options = {
            icon: 2,
            title:gettext('提示'),
            btn: []
        };
        var form_data = $("#id_calculateform").serialize();
        $.ajax({
            url: url,
            type: "POST",
            dataType: "json",
            data: form_data,
            success: function(callback){
                var ret = callback.ret;
                if(ret == "0"){
                    refresh_current_page();
                };
                if(ret == 'exists'){
                    layer.close(att);
                    clearInterval(timer);
                    timer = true;
                    var user = callback.login_user;
                    var totally = callback.totally;
                    var waiting = callback.waiting;
                    var calculated = callback.calculated;
                    var start_time = callback.start_time;
                    var end_time = callback.end_time;
                    var options = {
                        title: 'Progress',
                        skin: 'action-dialog',
                        area: ['auto', 'auto'],
                        content: $("#id_exists"),
                        success: function (layero, index) {
                            $("#id_exists_tip").text("Calculating by " + user);
                            $("#id_exists_totally").text(totally);
                            $("#id_exists_waiting").text(waiting);
                            $("#id_exists_calculated").text(calculated);
                            $("#id_exists_start").text(start_time);
                            $("#id_exists_end").text(end_time);
                            $("#id_exists").show();
                        }
                    };
                    $(document).layerDialog(options);
                };
                if(ret == 'emp_null'){
                    layer.close(att);
                    clearInterval(timer);
                    timer = true;
                    layer.alert(gettext("Please select the employees."), alert_options);
                };
                if(ret == 'sys_error'){
                    layer.close(att);
                    clearInterval(timer);
                    timer = true;
                    layer.alert(gettext("System busy."), alert_options);
                };
                if(ret == 'done'){
                    //layer.close(att);
                    var stamp = new Date().getTime();
                    var totally = callback.totally;
                    var waiting = callback.waiting;
                    var calculated = callback.calculated;
                    $("#id_totally").text(totally);
                    $("#id_calculated").text(calculated);
                    $("#id_waiting").text(waiting);
                    $("#id_progresser").progressBar(100, {increment:100,barImage: '/media/images/progressbg_green.gif?stamp='+stamp});
                    $("#id_progresser").show();
                    setTimeout(function(){
                        clearInterval(timer);
                        $("#info-panel").append('<div><img src="/media/img/icon-yes.gif" alt="Yes"><span>Calculating finish.</span></div>');
                        $("#id_progresser").progressBar(0, {increment:100,barImage: '/media/images/progressbg_green.gif?stamp='+stamp});
                        if(calc == "payroll"){
                            refresh_current_page();
                        }
                    }, 2000)
                }
            },
            error: function(a,b,c){
                layer.close(att);
                clearInterval(timer);
                timer = true;
                layer.alert(gettext("System busy."), alert_options);
            }
        })
    }, function(index){
        layer.close(index);
        return ;
    });
}
function N2(nc){
	var tt= "00" + nc.toString();
    tt=tt.toString();
    return tt.substr(tt.length-2);
}
function init_payroll_report() {
    $("body").removeClass("indexBody").css("width", "auto");
    $(".rightBox").eq(1).attr("class", "rightBox1");
    $(".leftBox").eq(1).remove();
    render_widgets($("#id_calculateform"));
    var td =new Date();
    $("#id_cometime").val(td.getFullYear()+"-"+N2((td.getMonth()+1))+"-01");
	$("#id_endtime").val(td.getFullYear()+"-"+N2((td.getMonth()+1))+"-"+N2(td.getDate()));
    $("#id_att_calculate").click(function(){
        calculate("att");
    });
    $("#id_payroll_calculate").click(function(){
        calculate("payroll");
    });
    $("#id_query").click(function(){
		 refresh_current_page();
	});
};


$(function(){
	init_payroll_report();
});